/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchIHasPackages;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchUnixOS;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.NetworkChecks;

public class OCFSPackagesChecks {
    public static final String UNIPROCESSOR = "uniprocessor";
    public static final String SMP = "smp";
    public static final String HUGEMEM = "hugemem";
    public static final String MODULEINFO_FILE = "/proc/modules";
    public static final String OCFS_MODULE_NAME = "ocfs";

    private OCFSPackagesChecks() {
    }

    public static OipcrIResult checkKernelModule(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oRes = OipcrResult.FAILED_RESULT;
        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
        Object[] args = new String[]{OCFS_MODULE_NAME};
        String sExpected = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.CRSRACPrereqsRuntimeRes", (String)"S_KERNEL_MODULE_FOUND", (Object[])args);
        boolean bFound = false;
        String sFound = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(MODULEINFO_FILE));
            String line = null;
            while ((line = br.readLine()) != null) {
                String moduleName;
                StringTokenizer tk = new StringTokenizer(line);
                if (tk.countTokens() < 3 || !(moduleName = tk.nextToken()).equals(OCFS_MODULE_NAME)) continue;
                bFound = true;
                oRes = OipcrResult.PASSED_RESULT;
                break;
            }
        }
        catch (IOException e) {
            Object[] args1 = new String[]{MODULEINFO_FILE, OCFS_MODULE_NAME};
            sFound = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.CRSRACPrereqsRuntimeRes", (String)"S_KERNEL_MODULE_FILE_CORRUPT", (Object[])args1);
        }
        sFound = sFound.equals("") ? (bFound ? sExpected : OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.CRSRACPrereqsRuntimeRes", (String)"S_KERNEL_MODULE_NOT_FOUND", (Object[])args)) : sFound;
        String sPrivateNodes = null;
        ArrayList sPrivateNodesList = null;
        if (!bFound) {
            try {
                sPrivateNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, null);
            }
            catch (Exception e) {
                sPrivateNodesList = new ArrayList();
            }
            String[] sPrivateNodesArr = OiixVectorOps.list2StrArr(sPrivateNodesList);
            sPrivateNodes = OiixFunctionOps.implodeList((String[])sPrivateNodesArr, (String)" ");
        }
        oResDetails.add(new OipcrResultDetails((Object)sFound, sPrivateNodes, oRes));
        return new OipcrResult(oResDetails);
    }

    public static OipcrIResult checkPackages(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block18: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchOS oOS = oHost.getOS();
                    OipchVersion oVer = oOS.getOSVersion();
                    if (oOS instanceof OipchUnixOS) {
                        OipchIHasPackages oRefOS;
                        OipchIHasPackages oOSWithPackages = (OipchIHasPackages)((Object)oOS);
                        OipchUnixOS oUnixOS = (OipchUnixOS)oOS;
                        OipchKernelInfo oOSKernelInfo = oUnixOS.getKernel();
                        OipchVersion oKernelVersion = (OipchVersion)oOSKernelInfo.getProperty("VERSION").getValue();
                        String kernelVersion = oKernelVersion.getDisplayName();
                        String kernelType = UNIPROCESSOR;
                        if (kernelVersion.indexOf(SMP) != -1) {
                            kernelType = SMP;
                        } else if (kernelVersion.indexOf(HUGEMEM) != -1) {
                            kernelType = HUGEMEM;
                        }
                        OipchRefHost oRefhost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                        OipchIHasPackages oipchIHasPackages = oRefOS = oVer == null ? null : (OipchIHasPackages)((Object)oRefhost.getOSForVersion(oVer));
                        if (oRefOS != null) {
                            Iterator oExpectedPackages = oRefOS.getPackages();
                            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                            if (oExpectedPackages != null) {
                                while (oExpectedPackages.hasNext()) {
                                    OipchPackage oExpectedPackage = (OipchPackage)oExpectedPackages.next();
                                    String sExpectedPackage = oExpectedPackage.getDisplayName();
                                    if (!kernelType.equals(UNIPROCESSOR) && sExpectedPackage.indexOf(kernelType) == -1 || kernelType.equals(UNIPROCESSOR) && (sExpectedPackage.indexOf(SMP) != -1 || sExpectedPackage.indexOf(HUGEMEM) != -1)) continue;
                                    Iterator oActualPackages = oOSWithPackages.getPackages();
                                    String sActualPackage = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ002");
                                    OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                                    while (oActualPackages.hasNext()) {
                                        OipchPackage oActualPackage = (OipchPackage)oActualPackages.next();
                                        int iCompare = oActualPackage.compare(oExpectedPackage);
                                        if (iCompare == 1 || iCompare == 4) {
                                            oRes = OipcrResult.PASSED_RESULT;
                                            sActualPackage = oActualPackage.getDisplayName();
                                            break;
                                        }
                                        if (iCompare != 2) continue;
                                        oRes = OipcrResult.FAILED_RESULT;
                                        sActualPackage = oActualPackage.getDisplayName();
                                    }
                                    oResDetails.add(new OipcrResultDetails((Object)sActualPackage, (Object)sExpectedPackage, oRes));
                                }
                            } else {
                                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-11108", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11108")));
                                return oResult;
                            }
                            oResult = new OipcrResult(oResDetails);
                        } else {
                            Object[] args = new String[]{oOS == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ004") : oOS.getOSName(), oVer == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ005") : oVer.getDisplayName()};
                            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18001", (Object[])args)));
                        }
                        break block18;
                    }
                    Object[] args = new String[]{oOS == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ004") : oOS.getOSName(), oVer == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ005") : oVer.getDisplayName()};
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18001", (Object[])args)));
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }
}

